
<?php
//**************************************************************************
//  Copyright Dave Massey 2017  www.remgate.com
//**************************************************************************
echo "Event Received\n";
    // This script works only for SN000999+ three function widgets
        // event 0 - Motion detection
        // event 1 - Contact Open (usually a door)
        // event 2 - Contact Closed (usually a door)
        // event 3 - Alive Ping every hour

    
    //  incoming data from IoT device looks like:
    //  ?id=XXXXXXXYYYYYYETIME...........
    //    where XXXXXXX id the chip id of the 8266, may be from 6 to 8 digits
    //    where YYYYYY is future feature
    //    where E is the event number, single digit just before the "TIME" flag
    
    // update history............................................................
    // Initial service 8/24/2016 for testing
    
    
    $myid = isset($_REQUEST['id']) ? $_REQUEST['id'] : null; // read the ID sent
    if ($myid !== null) {    $myid = substr($myid, 0, strpos($myid, 'TIME'));}  //strip the TIME=xxxxxxxx
    
    $event = 99;         // examples: 0=motion; 1=Garage door open; 2=Garage door closed
    $textmail1 = "";     // text address of recepient #1
    $textmail2 = "";
    $textmail3 = "";
    $switchnumber = 99;  // switch number on IOS application for enabling or disabling text alerts
    $label = "";         // label you want displayed on text and log file
    $openflag = 0;       // 0=door closed
   
    
    // get the IP address device is sending from..................................
    if (!empty($_SERVER['HTTP_CLIENT_IP']))
    {
      $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))
     {
       $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
     } else {$ip = $_SERVER['REMOTE_ADDR'];}
   
    
    $event = substr($myid, -1);               // Get the last character of sent string which is the EVENT
    $wid = substr($myid, 0, -1);              // get the widget ID (chip id)
    $did = "SN" . $wid;                       // pre-pend SN onto serial number
    
    
    
    //  open the aconfig.TXT file to determine event versas switch number on IoT-Alerts IOS application
    //  get the labels that you want in log file and text alerts
    //  get the text addresses of upto 3 for alerts
    $filename = "aconfig.txt";
    $fp = fopen($filename, "r");
    $fz = filesize("aconfig.txt");            // how big is the file
    
    for ($i = 0; $i != $fz; $i++)             // scan entire file
    {
        $chr = fgetc($fp);                    // read each character
        if ($chr == "S")                      // found new line of data
        {
            $didtemp = $chr;
            do
            {
               $tempchr = fgetc($fp);
               if($tempchr != ";") {$didtemp = $didtemp . $tempchr;}
            } while ($tempchr != ";");
            if ($did == $didtemp)             // Find the serial number we are currently looking at?
            {
                                              // spin up to event number in configuration file
                $eventcfg = fgetc($fp);       // get the event number
                if($eventcfg == $event)       // is this our current event?
                {
                    fgetc($fp);
                    $switchnumber = fgetc($fp);          // get the IOS application switch number
                    $switchnumber = (int)$switchnumber;  // convert to integer
                    fgetc($fp);
                    
                    do
                    {
                        $tempchr = fgetc($fp); // get the label for message from config file "e.g. Garage door open"
                        if($tempchr != ";") {$label = $label . $tempchr;}
                    } while ($tempchr != ";");
                   
                    do
                    {
                        $tempchr = fgetc($fp); // get all the characters of the first text address from config file
                        if($tempchr != ";") {$textmail1 = $textmail1 . $tempchr;}
                    } while ($tempchr != ";");
                    
                    do
                    {
                        $tempchr = fgetc($fp); // get all the characters of the second text address from config file
                        if($tempchr != ";") {$textmail2 = $textmail2 . $tempchr;}
                    } while ($tempchr != ";");
                    
                    do
                    {
                        $tempchr = fgetc($fp); // get all the characters of the third text address from config file
                        if($tempchr != ";") {$textmail3 = $textmail3 . $tempchr;}
                    } while ($tempchr != ";");
                }
            }
        }
    }
    fclose($fp);
    
    
    // Build the message for text alerts.................................
    $datenow = date("Y/m/d");
    $timenow = date("H:i:s");
    if ($event == "0") {$msg = "\nAlert - " . $did . " " . $label . $datenow . " " . $timenow . " ID=" . $myid . "\n";}
    if ($event == "1") {$msg = "\nAlert - " . $did . " " . $label . $datenow . " " . $timenow . " ID=" . $myid . "\n";}
    if ($event == "2") {$msg = "\nAlert - " . $did . " " . $label . $datenow . " " . $timenow . " ID=" . $myid . "\n";}
    
    
    // Log the data in full historical log file
    
      $filename= $did . "elog.txt";                    // log ID + elog.txt (e.g. SN000999elog.txt)
      $fp=fopen($filename, "a");
      fwrite($fp, "\r\n");
      fwrite($fp, "ID=");
      fwrite($fp, $myid);
      fwrite($fp, "; ");
        if ($event == "0") {fwrite($fp, $label);}      // select ONE of these
        if ($event == "1") {fwrite($fp, $label);}
        if ($event == "2") {fwrite($fp, $label);}
        if ($event == "3") {fwrite($fp, "Ping at: ");}
      fwrite($fp, $datenow);
      fwrite($fp, " ");
      fwrite($fp, $timenow);
      fwrite($fp, " P=");
      fwrite($fp, $ip);
     fclose($fp);
    
    
    // open acon.TXT file to determine if we allow texts or not for this switch $switchnumber
    // switches are set from IOS application IoT-Alerts
    $spin = array(99,1,3,5,7,9,11,13,15,17,19);
    
    if($switchnumber != "99")                        // if = 99 then we don't have a valid switch
    {
      $filename = "acon.txt";
      $fp = fopen($filename, "r");
      $fz = filesize("acon.txt");                    // how big is the file
      $allowtext = "0";                              // default is dis-allow text
    
      for ($i = 0; $i != $fz; $i++)                  // scan entire file
      {
        $chr = fgetc($fp);                           // read each character
        if ($chr == "A")                             // found new line of data
        {
                                                     // spin up to switchnumber
            for ($j = 0; $j != $spin[$switchnumber]; $j++)
            {
              fgetc($fp);
            }
            $allowtext = fgetc($fp);                 // get enable bit for switchnumber
        }
      }
      fclose($fp);
    }
    
   // open the last event time file based on event number................
    if ($event == "0") {$filename= $did . "l0.txt";}
      else if ($event == "1") {$filename= $did . "l1.txt";}
        else if ($event == "2") {$filename= $did . "l2.txt";}
        else {exit;}                                //we have no valid event so exit
    
    $fp=fopen($filename, "r");
    
    $year = fgetc($fp) . fgetc($fp) . fgetc($fp) . fgetc($fp);// get the year
    fgetc($fp);
    $month = fgetc($fp) . fgetc($fp);               // get the month
    fgetc($fp);
    $day = fgetc($fp) . fgetc($fp);                 // get the day
    fgetc($fp);fgetc($fp);
    $hour = fgetc($fp) . fgetc($fp);                // get the hour
    fgetc($fp);
    $min = fgetc($fp) . fgetc($fp);                 // get the min
    if ($event == "1")                              // if event = 1 door open and read last1 file to determine
    {                                               // if we should text again or not, ONLY text once when open
      fgetc($fp); fgetc($fp);                       // no matter how long door is open
      fgetc($fp); fgetc($fp); fgetc($fp);
      $openflag = fgetc($fp);
    }
    
    // get the time in the file of the last event
    $hourint = (int)$hour;                          // now have the hour
    $minint = (int)$min;                            // now have the min
    $dayint = (int)$day;                            // now have the day of month
    $monthint = (int)$month;                        // now have the  month
    $yearint = (int)$year;                          // now have the  year
    
    // get the time NOW
    $yearnow = date("Y");
    $monthnow = date("m");
    $daynow = date("d");
    $hournow = date("H");
    $minnow = date("i");
    
    $yearnowint = (int)$yearnow;
    $monthnowint = (int)$monthnow;
    $daynowint = (int)$daynow;
    $hournowint = (int)$hournow;
    $minnowint = (int)$minnow;
    
    // if beyond the same hour, send TEXT............
    $toggle = 0;               // dont send any text the same hour unless overridden by openflag test below
    if($yearnowint > $yearint) {$toggle = 1;}
    if($monthnowint > $monthint) {$toggle = 1;}
    if($daynowint > $dayint) {$toggle = 1;}
    if($hournowint > $hourint) {$toggle = 1;}
    
    
    if($event == "1")                               // dont text if openflag is set and event = 1
    {
       if($openflag == "1")
       {
         $toggle = 0;
       } else
        {
          $toggle = 1;
        }
    }
    if($toggle == 1)                                // we dont want to text door more than once
    {
        if($allowtext == "1")                       // only text event if enabled by IOS application
        {
            if($texmail1 != "nil"){ mail($textmail1," ",$msg,"From: IoT\r\n");}
            if($texmail2 != "nil"){ mail($textmail2," ",$msg,"From: IoT\r\n");}
            if($texmail3 != "nil"){ mail($textmail3," ",$msg,"From: IoT\r\n");}
        }
    }
    fclose($fp);
    
    // Save the last event for TEXT toggle ...................................
    // open the event file we are looking at now
    $filename = $did . "temp.txt";
    if ($event == "0") {$filename= $did . "l0.txt";}
    if ($event == "1") {$filename= $did . "l1.txt";}
    if ($event == "2") {$filename= $did . "l2.txt";}
    $fp=fopen($filename, "w");                      // overwrite the last event
    fwrite($fp, $datenow);
    fwrite($fp, "  ");
    fwrite($fp, $timenow);
    if ($event == "1")
    {
      fwrite($fp, " ");
      fwrite($fp, "F");
      fwrite($fp, "1");                             // write the door OPEN flag into the last1 file
    }
    fclose($fp);
    
    // if event 2 door closed then write flag into last1 file
    $filename = $did . "temp.txt";
    if ($event == "2")
    {
      $filename= $did . "l1.txt";
      $fp=fopen($filename, "w");                    // overwrite the last event
      fwrite($fp, $datenow);
      fwrite($fp, "  ");
      fwrite($fp, $timenow);
      fwrite($fp, " ");
      fwrite($fp, "F");
      fwrite($fp, "0");                             // write the door CLOSED flag into the last1 file
      fclose($fp);
    }
    
    
?>

