--**************************************************************************
--  Copyright Dave Massey 2017  www.remgate.com
--**************************************************************************
--
-- ************* modo01   ***********************************************
-- Main program to read motion sensor and check for door contact open and close
--  
------------------------------------------------------------------------------- 
print("main prog")
print(ssid)
wifi.setmode(wifi.STATION)           -- setup WIFI as station
wifi.sta.config(ssid, pass)          -- start WIFI with configured credentials
chip = node.chipid()                 -- get the chip id for sending to server
-------------------------------------------------------------------------------
function motion()                    -- function to test to see if we have motion
                                     -- call server if motion is active
  if gpio.read(1) == 1 then          -- is motion sensor ON???
    print("motion detected")
    gpio.write(6,gpio.HIGH)          -- Turn GREEN LED ON
    event = 0                        -- 0 = MOTION event
    dofile("modo01get.lc")           -- call server to update cloud
  end  -- end of read if
end  -- end of motion function

-------------------------------------------------------------------------------
function door()                      -- function to test to see if door is open                                  
  if gpio.read(11) == 1 then         -- is door open? D4 = 1
    if dooropen == 0 then            -- was closed before
      dooropen = 1                   -- now set door open flag
      print("door open detected")
      gpio.write(5,gpio.HIGH)        -- Turn BLUE LED ON
      event = 1                      -- 1 = DOOR OPEN event
      dofile("modo01get.lc")         -- call server to update cloud
    end
  else                               -- else door is closed D4 = 0
    if dooropen == 1 then            -- was open before
      dooropen = 0                   -- now set door closed flag
      print("door closed detected")
      gpio.write(5,gpio.HIGH)        -- Turn BLUE LED ON
      event = 2                      -- 2 = DOOR CLOSED event
      dofile("modo01get.lc")         -- call server to update cloud
    end
  end  -- end of read if
end  -- end of door function

------------------------------------------------------------------------------
function ping()                      -- function to send alive ping to server
                                     -- call server every hour to ping
  event = 3                          -- 1 = PING event
  print("ping")
  dofile("modo01get.lc")             -- call server to update cloud

  tmr.alarm( 4, 10000, 0, function()  
    if dooropen == 1 then            -- if door is still open then send status
      print("door is still open")
      event = 1
      dofile("modo01get.lc")         -- call server to update cloud
    end
  end ) 
end  -- end of Ping function
------------------------------------------------------------------------------

                                     -- run motion sensor check every 5 seconds
tmr.alarm( 1, 5000, 1, function() motion() end )
                                     -- run door check every 6.25 seconds
tmr.alarm( 2, 6250, 1, function() door() end )
                                     -- ping server every hour
tmr.alarm( 3, 3600000, 1, function() ping() end )
