--**************************************************************************
--  Copyright Dave Massey 2017  www.remgate.com
--**************************************************************************
--
-- ************* Startup file ***********************************************
-- initialization program to determine if the configuration button is pressed
--   while being booted up.  If so then start the IOTDevlo.lua program
--   to accept credentials and configuration data from an IOS device
--   If button is not pressed then start the main program modo01.lua
-----------------------------------------------------------------------------
gpio.mode(11,gpio.INPUT)   --configure D11 for door/contact input
gpio.mode(1,gpio.INPUT)    --configure D1 for motion input
gpio.mode(2,gpio.INPUT)    --configure D2 for IoTLoader input
gpio.mode(5,gpio.OUTPUT)   --configure D5 for BLUE LED output
gpio.mode(6,gpio.OUTPUT)   --configure D6 for GREEN LED output
gpio.mode(7,gpio.OUTPUT)   --configure D7 for RED LED output

gpio.write(5,gpio.LOW)     --turn OFF all LED's
gpio.write(6,gpio.LOW)
gpio.write(7,gpio.LOW)

goodconfig = 0            -- configuration and credentials file is valid
dooropen = 0              -- door contact open or closed
---------------------------------------------------------------------------
function flasherror()     -- Flash error indicating that configuration file
			  -- did not read properly, this is an endless loop
			  -- function and device must be power cycled and 
                          -- reloaded by IOS
  tmr.delay(500000)
  gpio.write(7,gpio.HIGH) -- RED LED
  tmr.delay(500000)
  gpio.write(7,gpio.LOW)
end
---------------------------------------------------------------------------
-- read the credential/configuration file to extract parameters we need for
-- the IoT device main program

function read_setting(name)
print("readsettings")
  if (file.open(name)~=nil) then
      --extract the credentials and configuration info
      ssid = string.sub(file.readline(), 1, -2) -- to remove newline character
      pass = string.sub(file.readline(), 1, -2) -- to remove newline character
      serv = string.sub(file.readline(), 1, -2) -- to remove newline character
      user = string.sub(file.readline(), 1, -2) -- to remove newline character
      snnu = string.sub(file.readline(), 1, -2) -- to remove newline character
     --append user and snnu for needed stuff
     -- snnu currently is not used
      user = "/u"..user.."/eaction.php";         -- make path e.g. /u0099/eaction.php
      file.close()
      goodconfig = 1                -- we have good config data
      return ssid, pass, serv, user, snnu
  else                              -- config data is invalid
      tmr.alarm(3, 1010, 1, function() flasherror() end )  -- flash the RED LED if error
      return "DAVE", "12345678", "www.myserv.com", "0099", "000999"
  end
end

---------------------------------------------------------------------------
  if gpio.read(2) == 0 then   -- D2 button is pushed
print("D2 pushed")
    tmr.alarm(0, 2000, 0, function() dofile("IOTDevlo.lc") end)
  else                        -- run normal operational file
    ssid, pass, serv, user, snnu = read_setting('credentials')  
  end                         -- end of read if/else
---------------------------------------------------------------------------
-- Start main program for motion or doors if we have good configuration data
 if goodconfig == 1 then
   print("Wait 2 seconds please")   -- wait 2 seconds too allow for file removal
   tmr.alarm(0, 2000, 0, function() dofile("modo01.lc") end)
 end    
   


 
