--**************************************************************************
--  Copyright Dave Massey 2017  www.remgate.com
--**************************************************************************
--
-- ************* IoTLoaderv2    ***********************************************
-- Make this device an access point that IOS device can connect to
--   to load wifi credentials and configuration mode parameters
------------------------------------------------------------------------------- 
 
-- Setup the device as a server that the IOS device can connect to such that
-- credentials and configuration can be loaded to EEPROM memory for use
-- by the main program

 wifi.setmode(wifi.STATIONAP)    -- setup device as a server for the IOS
 local cfg={}                    -- Static LAN IP
 cfg.ip="192.168.4.1"            -- fixed any IOT device
 cfg.netmask="255.255.255.0"
 cfg.gateway="192.168.4.1"   
 wifi.ap.config({ssid="IOTDevice",pwd="12345678"}) 
 wifi.ap.setip(cfg)
------------------------------------------------------------------------------- 

 gpio.write(5,gpio.HIGH)         -- Turn BLUE LED On indicating we are LOAD mode
 print("CC Load Mode")

-------------------------------------------------------------------------------

-- write credentials and configuration to a file in EEPROM so main program can 
--  access and load local wifi and functionality desired

 function save_credentials(name, ssid, pass, serv, user, snnu)
  file.open(name, 'w')           -- Open file and overwrite
  file.writeline(ssid)
  file.writeline(pass)
  file.writeline(serv)
  file.writeline(user)
  file.writeline(snnu)
  file.close()
  gpio.write(5,gpio.LOW)         --Turn BLUE LED OFF indicating we are done
 end
-------------------------------------------------------------------------------
 
-- create server to listen and accept data

srv=net.createServer(net.TCP)  
 srv:listen(80,function(conn)  
     conn:on("receive", function(client,request) 
     client:send("GET /HTTP/1.1\r\nHost: 192.168.4.1\r\n".."Connection: keep-alive\r\nAccept:*/*\r\n\r\n")
         local buf = ""; 
         local _, _, method, path, vars = string.find(request, "([A-Z]+) (.+)?(.+) HTTP"); 
         if(method == nil)then  
             _, _, method, path = string.find(request, "([A-Z]+) (.+) HTTP");  
         end 
       
        -- extract the credentials and configuration
          local _, _, ssid = string.find(vars, "ssid=(%w+)");              --expects "xxxxxx" letters and numbers
          local _, _, pass = string.find(vars, "pass=(%w+)");              --expects "xxxxxx" letters and numbers
          local _, _, serv = string.find(vars, "serv=(%w+.%w*.%a*)");      --expects "www.xxx.ccc"
          local _, _, user = string.find(vars, "user=(%w+)");              --expects "numbers       /xxx/yyy/filename.ccc"
          local _, _, snnu = string.find(vars, "snnu=(%w+)");              --expects "numbers"

        

        -- write the credentials to EEPROM file named "credentials" for main program use
          save_credentials('credentials', ssid, pass, serv, user, snnu)
          print("CC loaded")
print(ssid);
print(pass);
print(serv);
print(user);
print(snnu);

        -- send credentials back to IOS device for verification ack
         buf = buf.." ";
         buf = buf.."RESPONSE=";
         buf = buf.." ";
         buf = buf..ssid;
         buf = buf.." ";
         buf = buf..pass;
         buf = buf.." ";
         buf = buf..serv;
         buf = buf.." ";
         buf = buf..user;
         buf = buf.." ";
         buf = buf..snnu;
         
         client:send(buf); 
         client:close();
         collectgarbage(); 
     end) 
 end)
 
